const float B = 3950;
const float R = 10000.0;
const float RT0 = 10000.0;
const float T0 = 298.15;
const float Vcc = 5.0;
const float setPoint = 25.0;
const float isteresi = 1.0;
//Variables
int pinVentola=11;
float Rs, VR, I, Ts, Vs;
bool attivaRiscaldamento= false;
long t_attivazione=0;

void setup()
{
	pinMode(pinVentola, OUTPUT);
	Serial.begin ( 9600);
}

void loop()
{
	Vs = analogRead(A0); // 0-1023 tensione sul termistore
	Vs = (5.00 / 1023.00) * Vs; // converto in Volt
	VR = Vcc - Vs; // tensione sulla resistenza R da 10K
	I = VR/R;
	Rs = Vs/I; // Resistenza di Rs (V/I)
	Ts =1/ (log(Rs/ RT0) / B + 1 / T0); //Ts in K
	Ts = Ts - 273.15; //Conversion to °C
	// LOGICA CON ISTERESI
	if (Ts < (setPoint - isteresi)) {
		attivaRiscaldamento = true;
	}
	else if (Ts > (setPoint + isteresi)) {
		attivaRiscaldamento = false;
	}
	// ATTUAZIONE LOGICA
	if (millis() - t_attivazione >1000) {
	t_attivazione = millis();
		 Serial.print("T:"); Serial.print(Ts); Serial.print("C ");
		 if (attivaRiscaldamento) {
		 	digitalWrite(pinVentola, HIGH); // ON
			Serial.println("Accendo");
		 } else {
		 	Serial.println("Spengo");
		 	digitalWrite(pinVentola, LOW); // OFF
		 }
	}
	
}
