/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.util.Arrays;
import java.util.List;
import org.fife.ui.rsyntaxtextarea.modes.CPlusPlusTokenMaker;
import processing.app.syntax.PdeKeywords;

public class SketchTokenMaker
extends CPlusPlusTokenMaker {
    private static final List<Integer> COMMENT_TOKEN_TYPES = Arrays.asList(3, 1, 4, 5, 2);
    private final PdeKeywords pdeKeywords;

    public SketchTokenMaker(PdeKeywords pdeKeywords) {
        this.pdeKeywords = pdeKeywords;
    }

    public void addToken(char[] array, int start, int end, int tokenType, int startOffset, boolean hyperlink) {
        if (start > end) {
            super.addToken(array, start, end, tokenType, startOffset, hyperlink);
            return;
        }
        if (COMMENT_TOKEN_TYPES.contains(tokenType)) {
            super.addToken(array, start, end, tokenType, startOffset, hyperlink);
            return;
        }
        int newType = this.pdeKeywords.getTokenType(array, start, end);
        if (newType > -1) {
            tokenType = newType;
        }
        super.addToken(array, start, end, tokenType, startOffset, hyperlink);
    }
}

