/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import sun.security.util.Length;

abstract class Key
implements java.security.Key,
Length {
    private static final long serialVersionUID = -1088859394025049194L;
    protected NativeHandles handles;
    protected int keyLength = 0;

    protected Key(NativeHandles nativeHandles, int n) {
        this.handles = nativeHandles;
        this.keyLength = n;
    }

    private static native void cleanUp(long var0, long var2);

    @Override
    public int length() {
        return this.keyLength;
    }

    public long getHCryptKey() {
        return this.handles.hCryptKey;
    }

    public long getHCryptProvider() {
        return this.handles.hCryptProv;
    }

    @Override
    public abstract String getAlgorithm();

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    protected static native String getContainerName(long var0);

    protected static native String getKeyType(long var0);

    static class NativeHandles {
        long hCryptProv = 0L;
        long hCryptKey = 0L;

        public NativeHandles(long l, long l2) {
            this.hCryptProv = l;
            this.hCryptKey = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                NativeHandles nativeHandles = this;
                synchronized (nativeHandles) {
                    Key.cleanUp(this.hCryptProv, this.hCryptKey);
                    this.hCryptProv = 0L;
                    this.hCryptKey = 0L;
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

