int pinVentola=8;
const float B = 3950;
const float R = 10000.0;
const float RT0 = 10000.0;
const float T0 = 298.15;
const float Vcc = 5.0;

//Variables
float Rs, VR, I, Ts, Vs;

void setup() 
{
  pinMode(pinVentola, OUTPUT);
  Serial.begin ( 9600);
}

void loop() 
{
  int btnAvvio= digitalRead(12);

  Vs = analogRead(A0); // 0-1023 tensione sul termistore
  Vs = (5.00 / 1023.00) * Vs; // converto in Volt
  VR = Vcc - Vs; // tensione sulla resistenza R da 10K
  I = VR/R;  // corrente che circola nel sensore Rs
  Rs = Vs/I; // resistenza di Rs (V/I)
  Ts =1/ (log(Rs/ RT0) / B + 1 / T0); //Ts in K
  Ts = Ts - 273.15; //Conversion to °C
  
  Serial.print("T= ");
  Serial.print(Ts);
  Serial.println(" C");

  if (Ts>=30) {
    Serial.println("Ventola ON");
    digitalWrite(pinVentola,HIGH);
  }
  else {
    Serial.println("Ventola OFF");
    digitalWrite(pinVentola,LOW);
  }

  delay( 2000 );
}
