//CONTROLLO ON-OFF

#include <TimerOne.h>

const float Tsp= 25;
const int Pel_max= 1000;
// Variabile globale (usiamo 'volatile' perché modificata in un interrupt)
volatile float Tstanza = 0;

long t0=0;
float flagSpento= false;

void setup() {
  Serial.begin(9600);
  // Inizializza il timer con un periodo di 100.000 microsecondi (100ms)
  Timer1.initialize(50000); 
  // Collega la funzione all'interrupt del timer
  Timer1.attachInterrupt(aggiornaVariabile); 
  Serial.println("Controllo T avviato...");
}

void loop() {
  if (Tstanza>= Tsp) {
    flagSpento= true;
  }
  else {
    flagSpento= false;
  }
 
  Serial.print(millis()/1000); Serial.print(";"); Serial.println(Tstanza);
  delay(1000);
}

// Funzione richiamata dal timer (ISR - Interrupt Service Routine)
void aggiornaVariabile() {
  if (flagSpento== false) {
     Tstanza = Camera(100);
  }
  else {
     Tstanza = Camera(0);
  }
}


float Camera(float Pel) { // heat input in W (or J/s)
  //float U = 1.771 ; // W/m2K thermal convection coefficient for Al passive
  float U = 5;
  float Ct = 1006; // J/Kg K
  float A = 2; // m2 area for convection
  float massa =0.1 ; // Kg
  float Tamb = 20; // °C
  static float T = Tamb; // °C
  static uint32_t last = 0;
  uint32_t interval = 50; // ms

  if (millis() - last >= interval) {
    last = millis();
    float Qd = U * A * (T - Tamb);
    //Serial.println(Qd);
    T = T + (Pel - Qd) * interval / 1000.0 / massa / Ct ;
  }

  return T;
}
