// Definizioni Pin
const int potPin=A0;
const int motorePin=3;
const int encoderPinA = 2; // Pin interrupt (Digital 2)
volatile long impulsi = 0; // Contatore impulsi (volatile perché usato in interrupt)
unsigned long tempoPrecedente = 0;
float rpm = 0;

// Parametro da regolare: quanti impulsi genera l'encoder per un giro completo?
const int impulsi_per_giro = 1; 

void setup() {
  Serial.begin(9600);
  
  pinMode(potPin, INPUT);
  pinMode(motorePin, OUTPUT);
  pinMode(encoderPinA, INPUT);
  
  // Collega l'interrupt: esegui 'contaImpulsi' ogni volta che il segnale sale (RISING)
  attachInterrupt(digitalPinToInterrupt(encoderPinA), contaImpulsi, RISING);
  
  Serial.println("Inizializzazione tachimetro...");
  analogWrite(motorePin,0);
}

void loop() {
  unsigned long tempoCorrente = millis();
  
  int velocita= map(analogRead(potPin), 0, 1023, 0, 255);
  analogWrite(motorePin,velocita);
   
  // Calcola gli RPM ogni secondo (1000 millisecondi)
  if (tempoCorrente - tempoPrecedente >= 3000) {
    
    // Disabilita temporaneamente gli interrupt per leggere il valore in sicurezza
    noInterrupts();
    long copiaImpulsi = impulsi;
    impulsi = 0; // Resetta il contatore per il prossimo secondo
    interrupts();
    
    rpm = (float(copiaImpulsi) / impulsi_per_giro) * 20.0;
    Serial.print("Tick/sec: ");
    Serial.print(copiaImpulsi);
    Serial.print(" | ");
    Serial.print(rpm);
    Serial.println(" RPM");
    
    tempoPrecedente = tempoCorrente;
  }
}

// Funzione chiamata dall'interrupt
void contaImpulsi() {
  impulsi++;
}