//   File:  LED_linear_levels_millis.pde
//
//   Use PWM to control the brightness of an LED.
//   Pattern is a linear ramp up to a constant, followed by a linear decrease back to the 
//   starting intensity.  Repeat indefinitely.  Timing is controlled  with reference to 
//   the internal clock via millis().  Switching between phases is determined with "if" 
//   statements that check the current time.  Timing and ramp parameters are gobal
//   variables that are computed once at startup.  Note that *all* times are in milliseconds
//  
//   Gerald Recktenwald,  gerry@me.pdx.edu,  21 August 2011

int  LED_pin = 11;                          //  must be one of 3, 5, 6, 9, 10 or 11

int   Vmin=20, Vmax=220;                    //  Min & max of ramp output
int   dtin, dtpause, dtex, t3, tcycle;      //  Timing parameters, all in milliseconds
double  ain, bin, aex, bex;                 //  Slopes and intercepts of linear output functions

// -------------
void setup() {                
  pinMode(LED_pin, OUTPUT);                 // Initialize pin for output

  dtin = 2000;                              //  Time interval for inhale (milliseconds)
  dtpause = 500;                            //  Time interval for pause after inhale (milliseconds)
  dtex = 2500;                              //  Time interval for exhale (milliseconds)
  t3 = dtin + dtpause;                      //  Time at end of the pause (milliseconds)
  tcycle = dtin + dtpause + dtex;           //  Total time for one cycle (milliseconds)
  
  // -- Use other time interval and range parameters to compute slopes and intercepts of v(t)
  ain = double(Vmax - Vmin)/double(dtin);   //  Slope during inhale
  bin = double(Vmin);                       //  Intercept during inhale
  aex = double(Vmin - Vmax)/double(dtex);   //  Slope during exhale
  bex = double(Vmax) - aex*double(t3);      //  Intercept during exhale
}

// -------------
void loop() {

  int  v;
  unsigned long t, tstart;

  //  save tstart, so that t = millis() - tstart is zero at beginning of loop function
  tstart = millis();
  t = 0;

  while ( t < tcycle ) {

    if ( t <= dtin ) {
      v = int( ain*double(t) + bin );
    } else if ( t <= t3 ) {
      v = Vmax;
    } else {
      v = int( aex*double(t) + bex );
    }
    analogWrite(LED_pin, v);

    //  Get ready for next pass through the loop
    t = millis() - tstart;
    if ( t<0 ) break;       //  Fix roll-over every 50 days or so
  }
}
