//   File:  LED_three_level_loops.pde
//
//   Use PWM to control the brightness of an LED.
//   Repeat a pattern of three brightness levels where the time delay
//   for each brightness is controlled by a loop.
// 
//   Gerald Recktenwald,  gerry@me.pdx.edu,  20 August 2011

int  LED_pin = 11;                   //  must be one of 3, 5, 6, 9, 10 or 11

void setup() {                
  pinMode(LED_pin, OUTPUT);          // Initialize pin for output
}

void loop() {

  int  dtwait=500;                   //  Time delay during each loop
  int  i, nin=4, npause=1, nex=5;    //  Index (i) and number of repetitions for each loop
  int  Vin=20, Vpause=220, Vex=80;   //  8-bit output values for PWM duty cycle 

  for ( i=1; i<=nin; i++ ) {         //  Inhale
    analogWrite(LED_pin, Vin);
    delay(dtwait);
  }

  for ( i=1; i<=npause; i++ ) {      //  Pause
    analogWrite(LED_pin, Vpause);
    delay(dtwait);
  }
  
  for ( i=1; i<=nex; i++ ) {         //  Exhale
    analogWrite(LED_pin, Vex);
    delay(dtwait);
  }
}
