/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.controls;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.controls.AdvancedPanel;
import edu.colorado.phet.circuitconstructionkit.controls.ResetDynamicsButton;
import edu.colorado.phet.circuitconstructionkit.controls.ResistivitySlider;
import edu.colorado.phet.circuitconstructionkit.controls.ShowReadoutPanel;
import edu.colorado.phet.circuitconstructionkit.controls.SizeControlPanel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.persistence.CircuitXML;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNodeFactory;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.servicemanager.InputStreamFileContents;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.HelpPanel;
import edu.colorado.phet.common.phetcommon.view.PhetTitledBorder;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLWriter;

public class CCKControlPanel
extends ControlPanel {
    private CCKModule module;
    private JCheckBox seriesAmmeter;
    private JPanel advancedPanel;
    private boolean debugging = false;

    public CCKControlPanel(final CCKModule cCKModule, Module module) {
        this.module = cCKModule;
        JPanel jPanel = this.getFilePanel();
        if (this.useAdvanced()) {
            this.advancedPanel = new AdvancedControlPanel(cCKModule);
        }
        this.add(jPanel);
        if (cCKModule.getParameters().isUseVisualControlPanel()) {
            this.add(this.makeVisualPanel());
        }
        this.add(this.makeToolPanel());
        this.add(new SizeControlPanel(cCKModule));
        if (this.debugging) {
            JButton jButton = new JButton("Test Lifelike/Schematic");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < 100; ++i) {
                        cCKModule.setLifelike(!cCKModule.isLifelike());
                    }
                }
            });
            this.add(jButton);
        }
        if (this.useAdvanced()) {
            this.add(this.advancedPanel);
        }
        if (cCKModule.getParameters().showGrabBag()) {
            this.addGrabBag();
        }
        if (cCKModule.getParameters().getAllowDynamics()) {
            this.addControl(new ResetDynamicsButton(cCKModule));
        }
        this.addResetAllButton(new Resettable(){

            public void reset() {
                cCKModule.resetAll();
            }
        });
        super.addControlFullWidth(new HelpPanel(module));
    }

    private void add(JComponent jComponent) {
        this.addControlFullWidth(jComponent);
    }

    private boolean useAdvanced() {
        return this.module.getParameters().getUseAdvancedControlPanel();
    }

    private void addGrabBag() {
        this.module.addGrabBag();
    }

    private JPanel makeToolPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        try {
            ImageIcon imageIcon = new ImageIcon(ImageLoader.loadBufferedImage("circuit-construction-kit/images/dvm-thumb.gif"));
            ImageIcon imageIcon2 = new ImageIcon(ImageLoader.loadBufferedImage("circuit-construction-kit/images/va-thumb.gif"));
            ImageIcon imageIcon3 = new ImageIcon(ImageLoader.loadBufferedImage("circuit-construction-kit/images/ammeter60.gif"));
            final JCheckBox jCheckBox = new JCheckBox(CCKResources.getString("CCK3ControlPanel.VoltmeterCheckBox"), false);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CCKControlPanel.this.module.setVoltmeterVisible(jCheckBox.isSelected());
                }
            });
            final JCheckBox jCheckBox2 = new JCheckBox(CCKResources.getString("CCK3ControlPanel.NonContactAmmeterCheckBox"), false);
            jCheckBox2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CCKControlPanel.this.module.setVirtualAmmeterVisible(jCheckBox2.isSelected());
                }
            });
            this.seriesAmmeter = new JCheckBox(CCKResources.getString("CCK3ControlPanel.AmmeterCheckBox"), false);
            this.seriesAmmeter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CCKControlPanel.this.module.setSeriesAmmeterVisible(CCKControlPanel.this.seriesAmmeter.isSelected());
                }
            });
            jPanel.add((Component)jCheckBox, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            jPanel.add((Component)this.seriesAmmeter, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            if (this.module.getParameters().useNonContactAmmeter()) {
                jPanel.add((Component)jCheckBox2, gridBagConstraints2);
                ++gridBagConstraints2.gridy;
            }
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)new JLabel(imageIcon), gridBagConstraints);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)new JLabel(imageIcon3), gridBagConstraints);
            ++gridBagConstraints.gridy;
            if (this.module.getParameters().useNonContactAmmeter()) {
                jPanel.add((Component)new JLabel(imageIcon2), gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
            if (this.module.getParameters().getAllowDynamics()) {
                AbstractButton abstractButton;
                ImageIcon imageIcon4;
                try {
                    imageIcon4 = new ImageIcon(ImageLoader.loadBufferedImage("circuit-construction-kit/images/stopwatch-thumb.png"));
                    abstractButton = new JCheckBox(CCKStrings.getString("stopwatch"), this.module.isStopwatchVisible());
                    abstractButton.addActionListener(new ActionListener((JCheckBox)abstractButton){
                        final /* synthetic */ JCheckBox val$timerButton;
                        {
                            this.val$timerButton = jCheckBox;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            CCKControlPanel.this.module.setStopwatchVisible(this.val$timerButton.isSelected());
                        }
                    });
                    jPanel.add((Component)new JLabel(imageIcon4), gridBagConstraints);
                    jPanel.add((Component)abstractButton, gridBagConstraints2);
                    ++gridBagConstraints.gridy;
                    ++gridBagConstraints2.gridy;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                imageIcon4 = new ImageIcon(ImageLoader.loadBufferedImage("circuit-construction-kit/images/detector-thumb.gif"));
                jPanel.add((Component)new JLabel(imageIcon4), gridBagConstraints);
                abstractButton = new JButton(CCKStrings.getString("add.current.chart"));
                abstractButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        CCKControlPanel.this.module.addCurrentChart();
                    }
                });
                jPanel.add((Component)abstractButton, gridBagConstraints2);
                ++gridBagConstraints2.gridy;
                ++gridBagConstraints.gridy;
                ImageIcon imageIcon5 = new ImageIcon(ImageLoader.loadBufferedImage("circuit-construction-kit/images/detector-thumb.gif"));
                jPanel.add((Component)new JLabel(imageIcon4), gridBagConstraints);
                JButton jButton = new JButton(CCKStrings.getString("add.voltage"));
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        CCKControlPanel.this.module.addVoltageChart();
                    }
                });
                jPanel.add((Component)jButton, gridBagConstraints2);
            }
            jPanel.setBorder(new CCKTitledBorder(CCKResources.getString("CCK3ControlPanel.ToolsPanelBorder")));
            return jPanel;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    private JPanel makeVisualPanel() {
        final JRadioButton jRadioButton = new JRadioButton(CCKResources.getString("CCK3ControlPanel.LIfelikeRadioButton"), this.module.isLifelike());
        final JRadioButton jRadioButton2 = new JRadioButton(CCKResources.getString("CCK3ControlPanel.SchematicRadioButton"), !this.module.isLifelike());
        this.module.addBranchNodeFactoryListener(new BranchNodeFactory.Listener(){

            public void displayStyleChanged() {
                jRadioButton.setSelected(CCKControlPanel.this.module.isLifelike());
                jRadioButton2.setSelected(!CCKControlPanel.this.module.isLifelike());
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CCKControlPanel.this.module.setLifelike(true);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CCKControlPanel.this.module.setLifelike(false);
            }
        });
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        JPanel jPanel = new JPanel();
        jPanel.add(jRadioButton);
        if (this.module.getParameters().allowSchematicMode()) {
            jPanel.add(jRadioButton2);
        }
        ((Container)verticalLayoutPanel).add(jPanel);
        if (this.module.getParameters().allowShowReadouts()) {
            ((Container)verticalLayoutPanel).add(new ShowReadoutPanel(this.module));
        }
        verticalLayoutPanel.setBorder(new CCKTitledBorder(CCKResources.getString("CCK3ControlPanel.VisualPanelBorder")));
        return verticalLayoutPanel;
    }

    private void load() throws IOException, XMLException {
        Object object;
        FileOpenService fileOpenService = null;
        try {
            fileOpenService = PhetServiceManager.getFileOpenService(this.module.getSimulationPanel());
        }
        catch (UnavailableServiceException unavailableServiceException) {
            unavailableServiceException.printStackTrace();
        }
        FileContents fileContents = fileOpenService.openFileDialog(null, null);
        if (fileContents == null) {
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(fileContents.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = "";
        while (bufferedReader.ready()) {
            object = bufferedReader.readLine();
            System.out.println("read = " + (String)object);
            string = string + (String)object;
        }
        object = new StdXMLParser();
        object.setReader(new StdXMLReader(new StringReader(this.patchString(string))));
        object.setBuilder(new StdXMLBuilder());
        object.setValidator(new NonValidator());
        IXMLElement iXMLElement = (IXMLElement)object.parse();
        Circuit circuit = CircuitXML.parseXML(iXMLElement, this.module.getCircuitChangeListener(), this.module);
        if (this.isOldVersionCCK(string)) {
            this.flipY(circuit);
            PhetOptionPane.showMessageDialog(this, "<html>The file you loaded is from an earlier version of this program, <br>and some parts of the circuit may be oriented incorrectly.  <br><br>Manually correct any problems, and be sure to save the new circuit.</html>");
        }
        this.module.setCircuit(circuit);
    }

    private boolean isOldVersionCCK(String string) {
        return string.indexOf("edu.colorado.phet.cck3.circuit.Branch") >= 0 || string.indexOf("edu.colorado.phet.cck3.circuit.components.") >= 0;
    }

    private void flipY(Circuit circuit) {
        for (int i = 0; i < circuit.numJunctions(); ++i) {
            Junction junction = circuit.junctionAt(i);
            double d = junction.getY();
            double d2 = d - 5.0;
            double d3 = -d2;
            double d4 = 5.0 + d3;
            junction.setPosition(junction.getX(), d4);
        }
    }

    private String patchString(String string) {
        string = string.replaceAll("edu.colorado.phet.cck3.circuit.Branch", "edu.colorado.phet.cck.model.components.Wire");
        string = string.replaceAll("edu.colorado.phet.cck3.circuit.components.", "edu.colorado.phet.cck.model.components.");
        string = string.replaceAll("edu.colorado.phet.cck3.", "edu.colorado.phet.cck.");
        return string;
    }

    private void save() throws IOException {
        FileSaveService fileSaveService = null;
        try {
            fileSaveService = PhetServiceManager.getFileSaveService(this.module.getSimulationPanel());
        }
        catch (UnavailableServiceException unavailableServiceException) {
            unavailableServiceException.printStackTrace();
        }
        XMLElement xMLElement = CircuitXML.toXML(this.module.getCircuit());
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter(stringWriter);
        xMLWriter.write(xMLElement);
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + stringWriter.toString();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        InputStreamFileContents inputStreamFileContents = new InputStreamFileContents("circuitxml", byteArrayInputStream);
        FileContents fileContents = fileSaveService.saveFileDialog(null, null, inputStreamFileContents.getInputStream(), null);
        if (fileContents != null) {
            System.out.println("Saved to " + fileContents.getName() + " as: " + fileContents);
        }
    }

    private JPanel getFilePanel() {
        JButton jButton = new JButton(CCKResources.getString("CCK3ControlPanel.SaveButton"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CCKControlPanel.this.save();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        JButton jButton2 = new JButton(CCKResources.getString("CCK3ControlPanel.LoadButton"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CCKControlPanel.this.load();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        PhetTitledPanel phetTitledPanel = new PhetTitledPanel(CCKResources.getString("CCK3ControlPanel.FilePanelBorder"));
        phetTitledPanel.add(jButton);
        phetTitledPanel.add(jButton2);
        return phetTitledPanel;
    }

    static class AdvancedControlPanel
    extends AdvancedPanel {
        private CCKModule module;
        private JDialog dialog;
        private ResistivitySlider resistivitySlider;
        private JCheckBox hideElectrons;

        public AdvancedControlPanel(final CCKModule cCKModule) {
            super(CCKResources.getString("CCK3ControlPanel.Enable"), CCKResources.getString("CCK3ControlPanel.Disable"));
            this.setBorder(new PhetTitledBorder(CCKResources.getString("CCK3ControlPanel.AdvancedPanelBorder")));
            this.module = cCKModule;
            this.resistivitySlider = new ResistivitySlider();
            this.addControl(this.resistivitySlider);
            this.resistivitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = AdvancedControlPanel.this.resistivitySlider.getValue();
                    if (d <= 0.0) {
                        new RuntimeException("Illegal resistivity: " + d).printStackTrace();
                    }
                    cCKModule.getResistivityManager().setResistivity(d);
                }
            });
            cCKModule.getResistivityManager().resistivity.addObserver(new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    AdvancedControlPanel.this.resistivitySlider.setValue(d);
                }
            });
            this.hideElectrons = new JCheckBox(CCKResources.getString("CCK3ControlPanel.HideElectronsCheckBox"), !cCKModule.isElectronsVisible());
            this.hideElectrons.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    cCKModule.setElectronsVisible(!AdvancedControlPanel.this.hideElectrons.isSelected());
                }
            });
            this.addControl(this.hideElectrons);
            JButton jButton = new JButton(CCKResources.getString("CCK3ControlPanel.CloseButton"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AdvancedControlPanel.this.dialog.setVisible(false);
                }
            });
        }
    }

    public static class CCKTitledBorder
    extends PhetTitledBorder {
        public CCKTitledBorder(String string) {
            super(string);
        }
    }
}

