/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.BulbDimension;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.ComponentDimension;
import edu.colorado.phet.circuitconstructionkit.model.ConstantDensityLayout;
import edu.colorado.phet.circuitconstructionkit.model.ElectronSet;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.ResistivityManager;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.mna.MNAAdapter;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public class CCKModel {
    private Circuit circuit;
    private MNAAdapter solver;
    private ResistivityManager resistivityManager;
    private ElectronSet particleSet;
    private ConstantDensityLayout layout;
    private boolean modelChanged = false;
    private CircuitChangeListener circuitChangeListener;
    private double aspectRatio = 1.2;
    private double modelWidth = 10.0;
    private double modelHeight = this.modelWidth / this.aspectRatio;
    private Rectangle2D.Double modelBounds = new Rectangle2D.Double(0.0, 0.0, this.modelWidth, this.modelHeight);
    public static double ELECTRON_DX = 0.28;
    public static final ComponentDimension RESISTOR_DIMENSION = new ComponentDimension(0.65, 0.3);
    public static final ComponentDimension CAP_DIM = new ComponentDimension(0.9, 0.3);
    public static final ComponentDimension AC_DIM = new ComponentDimension(0.65, 0.3);
    public static final ComponentDimension SWITCH_DIMENSION = new ComponentDimension(1.0875, 0.58);
    public static final ComponentDimension LEVER_DIMENSION = new ComponentDimension(0.725, 0.3625);
    public static final ComponentDimension BATTERY_DIMENSION = new ComponentDimension(0.95, 0.35);
    public static final ComponentDimension SERIES_AMMETER_DIMENSION = new ComponentDimension(1.165, 0.46);
    public static final ComponentDimension INDUCTOR_DIM = new ComponentDimension(1.25, 0.3);
    private static double bulbLength = 1.0;
    private static double bulbHeight = 1.5;
    private static double bulbDistJ = 0.39333;
    private static double bulbScale = 1.9;
    public static final BulbDimension BULB_DIMENSION = new BulbDimension(bulbLength * 0.5 * bulbScale, bulbHeight * 0.5 * bulbScale, bulbDistJ * 0.5 * bulbScale);
    public static final double WIRE_LENGTH = BATTERY_DIMENSION.getLength() * 1.2;
    int stepCount = 0;
    int frameSolveCount = 1;
    int N = 1;

    public CCKModel() {
        this.circuitChangeListener = new CircuitChangeListener(){

            public void circuitChanged() {
                CCKModel.this.modelChanged = true;
            }
        };
        this.circuit = new Circuit(this.circuitChangeListener);
        this.solver = new MNAAdapter();
        this.particleSet = new ElectronSet(this.getCircuit());
        this.layout = new ConstantDensityLayout(this.getCircuit(), this.particleSet);
        this.getCircuit().addCircuitListener(this.layout);
        this.resistivityManager = new ResistivityManager(this.getCircuit());
        this.getCircuit().addCircuitListener(this.resistivityManager);
    }

    public void stepInTime(double d) {
        ++this.stepCount;
        if ((this.getCircuit().isDynamic() || this.modelChanged) && this.stepCount % this.frameSolveCount == 0) {
            this.getCircuit().stepInTime(d);
            for (int i = 0; i < this.N; ++i) {
                this.solver.apply(this.getCircuit(), d / (double)this.N * (double)this.frameSolveCount);
            }
            this.modelChanged = false;
        }
        this.particleSet.stepInTime(d);
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public void layoutElectrons(Branch[] branchArray) {
        this.layout.layoutElectrons(branchArray);
    }

    public MNAAdapter getCircuitSolver() {
        return this.solver;
    }

    public ElectronSet getParticleSet() {
        return this.particleSet;
    }

    public Rectangle2D.Double getModelBounds() {
        return this.modelBounds;
    }

    public CircuitChangeListener getCircuitChangeListener() {
        return this.circuitChangeListener;
    }

    public ResistivityManager getResistivityManager() {
        return this.resistivityManager;
    }

    public void resetAll() {
        this.getCircuit().clear();
        this.getCircuit().clearSelection();
        this.getParticleSet().clear();
        this.resistivityManager.reset();
    }

    public Junction[] split(Junction junction) {
        Junction[] junctionArray = this.circuit.split(junction);
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        for (int i = 0; i < junctionArray.length; ++i) {
            Junction junction2 = junctionArray[i];
            arrayList.addAll(Arrays.asList(this.circuit.getAdjacentBranches(junction2)));
        }
        this.layoutElectrons(this.getCircuit().getBranches());
        return junctionArray;
    }

    public void setCircuit(Circuit circuit) {
        this.circuit.setState(circuit);
        this.layoutElectrons();
    }

    private void layoutElectrons() {
        this.layoutElectrons(this.circuit.getBranches());
    }

    public void deleteSelectedBranches() {
        this.circuit.deleteSelectedBranches();
    }

    public void selectAll() {
        this.circuit.selectAll();
    }

    public void desolderSelectedJunctions() {
        this.circuit.desolderSelectedJunctions();
    }

    public void clearSelection() {
        this.circuit.clearSelection();
    }
}

