/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.BranchSet;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.Electron;
import edu.colorado.phet.circuitconstructionkit.model.ElectronSet;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;

public class ConstantDensityLayout
extends CircuitListenerAdapter {
    private boolean dolayout = true;
    private Circuit circuit;
    private ElectronSet particleSet;
    private boolean electronsVisible = true;

    public ConstantDensityLayout(Circuit circuit, ElectronSet electronSet) {
        this.circuit = circuit;
        this.particleSet = electronSet;
    }

    public void branchesMoved(Branch[] branchArray) {
        if (!this.dolayout) {
            return;
        }
        BranchSet branchSet = new BranchSet(this.getCircuit(), branchArray);
        for (int i = 0; i < branchArray.length; ++i) {
            branchSet.addBranches(this.getCircuit().getStrongConnections(branchArray[i].getStartJunction()));
            branchSet.addBranches(this.getCircuit().getStrongConnections(branchArray[i].getEndJunction()));
        }
        Branch[] branchArray2 = branchSet.getBranches();
        this.layoutElectrons(branchArray2);
    }

    private Circuit getCircuit() {
        return this.circuit;
    }

    public void layoutElectrons(Branch[] branchArray) {
        for (int i = 0; i < branchArray.length; ++i) {
            Branch branch = branchArray[i];
            this.layoutElectrons(branch);
        }
    }

    private void layoutElectrons(Branch branch) {
        this.particleSet.removeParticles(branch);
        if (this.getElectronsVisible()) {
            double d = CCKModel.ELECTRON_DX / 2.0;
            double d2 = branch.getLength() - d;
            double d3 = d2 - d;
            double d4 = 1.0 / CCKModel.ELECTRON_DX;
            double d5 = d3 * d4;
            int n = (int)Math.ceil(d5);
            double d6 = (double)(n - 1) / d3;
            double d7 = 1.0 / d6;
            if (d6 == 0.0) {
                n = 0;
            }
            for (int i = 0; i < n; ++i) {
                this.particleSet.addParticle(new Electron(branch, (double)i * d7 + d));
            }
        }
    }

    private boolean getElectronsVisible() {
        return this.electronsVisible;
    }
}

