/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.analysis;

import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import java.util.ArrayList;
import java.util.Collections;

public class Path {
    private ArrayList entries = new ArrayList();

    public Path(Path path, Branch branch, Junction junction) {
        this.entries.addAll(path.entries);
        PathEntry pathEntry = new PathEntry(branch, junction);
        this.entries.add(pathEntry);
    }

    public Path(Branch branch, Junction junction) {
        this.entries.add(new PathEntry(branch, junction));
    }

    public Junction lastJunction() {
        return this.lastPathEntry().getJunction();
    }

    public PathEntry lastPathEntry() {
        return (PathEntry)this.entries.get(this.entries.size() - 1);
    }

    public boolean containsJunction(Junction junction) {
        for (int i = 0; i < this.entries.size(); ++i) {
            PathEntry pathEntry = (PathEntry)this.entries.get(i);
            if (!pathEntry.getBranch().hasJunction(junction)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Path)) {
            return false;
        }
        Path path = (Path)object;
        if (path.numPathEntries() != this.numPathEntries()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            PathEntry pathEntry;
            PathEntry pathEntry2 = (PathEntry)this.entries.get(i);
            if (pathEntry2.equals(pathEntry = (PathEntry)path.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    public Junction getStartJunction() {
        return this.entryAt(0).getBranch().opposite(this.entryAt(0).getJunction());
    }

    public String toString() {
        String string = "";
        string = string + this.getStartJunction().getLabel();
        for (int i = 0; i < this.entries.size(); ++i) {
            PathEntry pathEntry = (PathEntry)this.entries.get(i);
            string = string + " <" + pathEntry.getBranch().getName() + "> " + pathEntry.getJunction().getLabel();
        }
        return string;
    }

    public boolean containsBranch(Branch branch) {
        for (int i = 0; i < this.entries.size(); ++i) {
            PathEntry pathEntry = (PathEntry)this.entries.get(i);
            if (pathEntry.getBranch() != branch) continue;
            return true;
        }
        return false;
    }

    public boolean containsCapacitor() {
        for (int i = 0; i < this.entries.size(); ++i) {
            PathEntry pathEntry = (PathEntry)this.entries.get(i);
            if (!(pathEntry.getBranch() instanceof Capacitor)) continue;
            return true;
        }
        return false;
    }

    public double sumResistance() {
        double d = 0.0;
        for (int i = 0; i < this.entries.size(); ++i) {
            CircuitComponent circuitComponent;
            PathEntry pathEntry = (PathEntry)this.entries.get(i);
            if (pathEntry.getBranch() instanceof Resistor) {
                circuitComponent = (Resistor)pathEntry.getBranch();
                d += circuitComponent.getResistance();
                continue;
            }
            if (!(pathEntry.getBranch() instanceof Battery)) continue;
            circuitComponent = (Battery)pathEntry.getBranch();
            d += ((Battery)circuitComponent).getInteralResistance();
        }
        return d;
    }

    public static Path[] getLoops(Circuit circuit) {
        ArrayList arrayList = new ArrayList();
        long l = System.currentTimeMillis();
        for (int i = 0; i < circuit.numBranches(); ++i) {
            Branch branch = circuit.branchAt(i);
            Path path = new Path(branch, branch.getStartJunction());
            Path.addLoops(path, circuit, arrayList);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        return arrayList.toArray(new Path[0]);
    }

    private static void addLoops(Path path, Circuit circuit, ArrayList arrayList) {
        Junction junction = path.lastJunction();
        Branch[] branchArray = circuit.getAdjacentBranches(junction);
        for (int i = 0; i < branchArray.length; ++i) {
            Branch branch = branchArray[i];
            Junction junction2 = branch.opposite(junction);
            if (path.containsBranch(branch)) continue;
            if (path.containsJunction(junction2)) {
                Path path2;
                if (path.getStartJunction() != junction2 || !Path.isUniqueLoop(arrayList, path2 = new Path(path, branch, junction2))) continue;
                arrayList.add(path2);
                continue;
            }
            Path.addLoops(new Path(path, branch, junction2), circuit, arrayList);
        }
    }

    private static boolean isUniqueLoop(ArrayList arrayList, Path path) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Path path2 = (Path)arrayList.get(i);
            if (!path2.loopEquals(path)) continue;
            return false;
        }
        return true;
    }

    private boolean loopEquals(Path path) {
        if (this.equals(path)) {
            return true;
        }
        if (path.numPathEntries() != this.numPathEntries()) {
            return false;
        }
        if (this.loopEqualsSameDir(path)) {
            return true;
        }
        return this.loopEqualsOppositeDir(path);
    }

    public ArrayList getBranchList() {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        for (int i = 0; i < this.entries.size(); ++i) {
            PathEntry pathEntry = (PathEntry)this.entries.get(i);
            arrayList.add(pathEntry.getBranch());
        }
        return arrayList;
    }

    private boolean loopEqualsOppositeDir(Path path) {
        int n;
        ArrayList arrayList = path.getBranchList();
        ArrayList arrayList2 = this.getBranchList();
        Collections.reverse(arrayList2);
        int n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            arrayList2.add(arrayList2.get(n));
        }
        n = arrayList2.indexOf(arrayList.get(0));
        if (n == -1) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList2.get(n) != arrayList.get(i)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean loopEqualsSameDir(Path path) {
        int n = path.numPathEntries();
        int n2 = this.indexOf(path.entryAt(0));
        if (n2 == -1) {
            return false;
        }
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            if (!this.entryAt(n3).equals(path.entryAt(i))) {
                return false;
            }
            n3 = (n3 + 1) % n;
        }
        return true;
    }

    private int indexOf(PathEntry pathEntry) {
        for (int i = 0; i < this.entries.size(); ++i) {
            PathEntry pathEntry2 = (PathEntry)this.entries.get(i);
            if (!pathEntry2.equals(pathEntry)) continue;
            return i;
        }
        return -1;
    }

    private PathEntry entryAt(int n) {
        return (PathEntry)this.entries.get(n);
    }

    private int numPathEntries() {
        return this.entries.size();
    }

    public boolean containsVoltageSource() {
        for (int i = 0; i < this.entries.size(); ++i) {
            Battery battery;
            double d;
            PathEntry pathEntry = (PathEntry)this.entries.get(i);
            boolean bl = pathEntry.getBranch() instanceof Battery;
            if (!bl || (d = (battery = (Battery)pathEntry.getBranch()).getVoltageDrop()) == 0.0) continue;
            return true;
        }
        return false;
    }

    static class PathEntry {
        Branch branch;
        Junction endJunction;

        public PathEntry(Branch branch, Junction junction) {
            this.branch = branch;
            this.endJunction = junction;
            if (!branch.hasJunction(junction)) {
                throw new RuntimeException("Branch does not contain junction.");
            }
        }

        public Junction getJunction() {
            return this.endJunction;
        }

        public Branch getBranch() {
            return this.branch;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PathEntry)) {
                return false;
            }
            PathEntry pathEntry = (PathEntry)object;
            return this.branch.equals(pathEntry.branch) && this.endJunction.equals(pathEntry.endJunction);
        }
    }
}

