/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CCKDefaults;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.PathBranch;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Filament
extends PathBranch {
    private Junction shellJunction;
    private Junction tailJunction;
    private double resistorDY;
    private double resistorWidth;
    private ImmutableVector2D northDir;
    private ImmutableVector2D eastDir;
    private Point2D pin;
    private boolean connectAtRight = true;

    public Filament(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, int n, double d, double d2, double d3) {
        super(circuitChangeListener, junction, junction2);
        this.shellJunction = junction2;
        this.tailJunction = junction;
        this.resistorDY = d;
        this.resistorWidth = d2;
        this.recompute();
    }

    public void setConnectAtRight(boolean bl) {
        this.connectAtRight = bl;
        this.recompute();
    }

    public void setStartJunction(Junction junction) {
        super.setStartJunction(junction);
        this.tailJunction = junction;
        this.recompute();
    }

    public void setEndJunction(Junction junction) {
        super.setEndJunction(junction);
        this.shellJunction = junction;
        this.recompute();
    }

    private Point2D getPoint(double d, double d2) {
        ImmutableVector2D immutableVector2D = this.eastDir.getScaledInstance(d);
        ImmutableVector2D immutableVector2D2 = this.northDir.getScaledInstance(d2);
        ImmutableVector2D immutableVector2D3 = immutableVector2D.getAddedInstance(immutableVector2D2);
        return immutableVector2D3.getDestination(this.pin);
    }

    private ImmutableVector2D getVector(double d, double d2) {
        ImmutableVector2D immutableVector2D = this.eastDir.getScaledInstance(d);
        ImmutableVector2D immutableVector2D2 = this.northDir.getScaledInstance(d2);
        return immutableVector2D.getAddedInstance(immutableVector2D2);
    }

    public GeneralPath getPath() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(this.segmentAt(0).getStart());
        for (int i = 0; i < this.numSegments(); ++i) {
            PathBranch.Segment segment = this.segmentAt(i);
            doubleGeneralPath.lineTo(segment.getEnd());
        }
        return doubleGeneralPath.getGeneralPath();
    }

    boolean isNaN(ImmutableVector2D immutableVector2D) {
        return Double.isNaN(immutableVector2D.getX()) || Double.isNaN(immutableVector2D.getY());
    }

    public void recompute() {
        if (this.tailJunction == null || this.shellJunction == null) {
            return;
        }
        double d = CCKDefaults.determineTilt();
        if (!this.connectAtRight) {
            d = -d;
        }
        this.northDir = new Vector2D(this.tailJunction.getPosition(), this.shellJunction.getPosition()).getNormalizedInstance();
        this.northDir = this.northDir.getRotatedInstance(-d);
        this.eastDir = this.northDir.getNormalVector().getNormalizedInstance();
        if (!this.connectAtRight) {
            this.eastDir = this.eastDir.getScaledInstance(-1.0);
        }
        if (this.isNaN(this.northDir) || this.isNaN(this.eastDir)) {
            System.out.println("Bulb basis set is not a number.");
            return;
        }
        this.pin = this.shellJunction.getPosition();
        Point2D point2D = this.getPoint(-this.resistorWidth / 2.0, this.resistorDY);
        if (Double.isNaN(point2D.getX()) || Double.isNaN(point2D.getY())) {
            throw new RuntimeException("Point was nan: " + point2D);
        }
        super.reset(this.tailJunction.getPosition(), point2D);
        this.addPoint(this.getVector(-this.resistorWidth / 4.0, CCKModel.BULB_DIMENSION.getHeight() * 0.2));
        this.addPoint(this.getVector(this.resistorWidth * 0.68, 0.0));
        this.addPoint(this.pin);
    }
}

