/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.ACVoltageSource;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.Inductor;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.components.SeriesAmmeter;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.model.grabbag.GrabBagResistor;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.SchematicCapacitorNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.TotalBulbComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.ACVoltageSourceNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.BatteryNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.CapacitorNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.GrabBagResistorNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.InductorNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.ResistorNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.SeriesAmmeterNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.SwitchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.WireNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic.SchematicACNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic.SchematicBatteryNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic.SchematicInductorNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic.SchematicResistorNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic.SchematicSwitchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic.SchematicWireNode;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.util.ArrayList;
import javax.swing.JComponent;

public class BranchNodeFactory {
    private CCKModel cckModel;
    private JComponent component;
    private CCKModule module;
    private BooleanProperty lifelikeProperty;
    private ArrayList listeners = new ArrayList();

    public BranchNodeFactory(CCKModel cCKModel, JComponent jComponent, CCKModule cCKModule, BooleanProperty booleanProperty) {
        this.cckModel = cCKModel;
        this.component = jComponent;
        this.module = cCKModule;
        this.lifelikeProperty = booleanProperty;
        booleanProperty.addObserver(new SimpleObserver(){

            public void update() {
                BranchNodeFactory.this.notifyDisplayStyleChanged();
            }
        });
    }

    protected BranchNode createNode(Branch branch) {
        if (((Boolean)this.lifelikeProperty.get()).booleanValue()) {
            return this.createLifelikeNode(branch);
        }
        return this.createSchematicNode(branch);
    }

    private BranchNode createSchematicNode(Branch branch) {
        if (branch instanceof Wire) {
            return new SchematicWireNode(this.cckModel, (Wire)branch, this.component);
        }
        if (branch instanceof GrabBagResistor) {
            return new SchematicResistorNode(this.cckModel, (GrabBagResistor)branch, this.component, this.module);
        }
        if (branch instanceof Resistor) {
            return new SchematicResistorNode(this.cckModel, (Resistor)branch, this.component, this.module);
        }
        if (branch instanceof ACVoltageSource) {
            return new SchematicACNode(this.cckModel, (ACVoltageSource)branch, this.component, this.module);
        }
        if (branch instanceof Battery) {
            return new SchematicBatteryNode(this.cckModel, (Battery)branch, this.component, this.module);
        }
        if (branch instanceof Bulb) {
            return new TotalBulbComponentNode(this.cckModel, (Bulb)branch, this.component, this.module);
        }
        if (branch instanceof Switch) {
            return new SchematicSwitchNode(this.cckModel, (Switch)branch, this.component, this.module);
        }
        if (branch instanceof Capacitor) {
            return new SchematicCapacitorNode(this.cckModel, (Capacitor)branch, this.component, this.module);
        }
        if (branch instanceof Inductor) {
            return new SchematicInductorNode(this.cckModel, (Inductor)branch, this.component, this.module);
        }
        if (branch instanceof SeriesAmmeter) {
            return new SeriesAmmeterNode(this.component, (SeriesAmmeter)branch, this.module);
        }
        throw new RuntimeException("Unrecognized branch type: " + branch.getClass());
    }

    private BranchNode createLifelikeNode(Branch branch) {
        if (branch instanceof Wire) {
            return new WireNode(this.cckModel, (Wire)branch, this.component);
        }
        if (branch instanceof GrabBagResistor) {
            return new GrabBagResistorNode(this.cckModel, (GrabBagResistor)branch, this.component, this.module);
        }
        if (branch instanceof Resistor) {
            return new ResistorNode(this.cckModel, (Resistor)branch, this.component, this.module);
        }
        if (branch instanceof ACVoltageSource) {
            return new ACVoltageSourceNode(this.cckModel, (ACVoltageSource)branch, this.component, this.module);
        }
        if (branch instanceof Battery) {
            return new BatteryNode(this.cckModel, (Battery)branch, this.component, this.module);
        }
        if (branch instanceof Bulb) {
            return new TotalBulbComponentNode(this.cckModel, (Bulb)branch, this.component, this.module);
        }
        if (branch instanceof Switch) {
            return new SwitchNode(this.cckModel, (Switch)branch, this.component, this.module);
        }
        if (branch instanceof Capacitor) {
            return new CapacitorNode(this.cckModel, (Capacitor)branch, this.component, this.module);
        }
        if (branch instanceof Inductor) {
            return new InductorNode(this.cckModel, (Inductor)branch, this.component, this.module);
        }
        if (branch instanceof SeriesAmmeter) {
            return new SeriesAmmeterNode(this.component, (SeriesAmmeter)branch, this.module);
        }
        throw new RuntimeException("Unrecognized branch type: " + branch.getClass());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyDisplayStyleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.displayStyleChanged();
        }
    }

    public static interface Listener {
        public void displayStyleChanged();
    }
}

