/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.view.CCKLookAndFeel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitInteractionModel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.DynamicPopupMenuHandler;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.JunctionNodePopupMenu;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Stroke;
import javax.swing.JPopupMenu;

public class JunctionNode
extends PhetPNode {
    private CCKModel cckModel;
    private Junction junction;
    private PPath shapeNode;
    private PPath highlightNode;
    private CircuitInteractionModel circuitInteractionModel;

    public JunctionNode(final CCKModel cCKModel, final Junction junction, CircuitNode circuitNode, Component component) {
        this.cckModel = cCKModel;
        this.junction = junction;
        this.circuitInteractionModel = new CircuitInteractionModel(cCKModel);
        this.shapeNode = new PPath();
        BasicStroke basicStroke = new BasicStroke(2.0f);
        this.shapeNode.setStroke(basicStroke);
        this.shapeNode.setPaint(Color.blue);
        this.highlightNode = new PPath();
        this.highlightNode.setStroke(new BasicStroke(0.0375f));
        this.highlightNode.setStrokePaint(Color.yellow);
        this.highlightNode.setPickable(false);
        this.highlightNode.setChildrenPickable(false);
        this.addChild(this.shapeNode);
        this.addChild(this.highlightNode);
        junction.addObserver(new SimpleObserver(){

            public void update() {
                JunctionNode.this.update();
            }
        });
        this.shapeNode.setStrokePaint(Color.red);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                JunctionNode.this.circuitInteractionModel.dragJunction(junction, pInputEvent.getPositionRelativeTo(JunctionNode.this));
            }

            public void mousePressed(PInputEvent pInputEvent) {
                if (pInputEvent.isControlDown()) {
                    junction.setSelected(!junction.isSelected());
                } else {
                    JunctionNode.this.getCircuit().setSelection(junction);
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                JunctionNode.this.circuitInteractionModel.dropJunction(junction);
            }
        });
        this.addInputEventListener(new DynamicPopupMenuHandler(component, new DynamicPopupMenuHandler.JPopupMenuFactory(){

            public JPopupMenu createPopupMenu() {
                return new JunctionNodePopupMenu(cCKModel, junction);
            }
        }));
        this.addInputEventListener(new CursorHandler());
        this.update();
        circuitNode.getCircuit().addCircuitListener(new CircuitListenerAdapter(){

            public void junctionsConnected(Junction junction, Junction junction2, Junction junction3) {
                JunctionNode.this.update();
            }

            public void junctionsSplit(Junction junction, Junction[] junctionArray) {
                JunctionNode.this.update();
            }

            public void branchRemoved(Branch branch) {
                JunctionNode.this.update();
            }

            public void junctionRemoved(Junction junction) {
                JunctionNode.this.update();
            }
        });
    }

    private Stroke createStroke(double d) {
        float f = 80.0f;
        float[] fArray = new float[]{3.0f / f, 6.0f / f};
        return new BasicStroke((float)d, 2, 0, 3.0f, fArray, 0.0f);
    }

    private void update() {
        this.shapeNode.setPathTo(this.junction.getShape());
        double d = 0.015;
        this.shapeNode.setStroke(this.createStroke(d * (this.isConnected() ? 1.2 : 2.0)));
        this.shapeNode.setStrokePaint(this.isConnected() ? Color.black : Color.red);
        this.shapeNode.setPaint(this.isConnectedTo2Wires() ? CCKLookAndFeel.COPPER : new Color(0, 0, 0, 0));
        this.highlightNode.setPathTo(this.junction.createCircle(0.25920000000000004));
        this.highlightNode.setStroke(new BasicStroke(0.0375f));
        this.highlightNode.setVisible(this.junction.isSelected());
    }

    private boolean isConnectedTo2Wires() {
        Branch[] branchArray;
        if (!this.isConnected()) {
            return false;
        }
        for (Branch branch : branchArray = this.getCircuit().getAdjacentBranches(this.junction)) {
            if (branch instanceof Wire) continue;
            return false;
        }
        return true;
    }

    private boolean isConnected() {
        return this.getCircuit().getNeighbors(this.junction).length > 1;
    }

    public Junction getJunction() {
        return this.junction;
    }

    private Circuit getCircuit() {
        return this.cckModel.getCircuit();
    }
}

