/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ReadoutNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import java.text.DecimalFormat;

public class ReadoutSetNode
extends PhetPNode {
    private CCKModule module;
    private Circuit circuit;
    private SimpleObserver updater = new SimpleObserver(){

        public void update() {
            ReadoutSetNode.this.update();
        }
    };

    public ReadoutSetNode(CCKModule cCKModule, Circuit circuit) {
        this.module = cCKModule;
        this.circuit = circuit;
        circuit.addCircuitListener(new CircuitListenerAdapter(){

            public void branchRemoved(Branch branch) {
                ReadoutSetNode.this.removeBranchReadout(branch);
            }

            public void branchAdded(Branch branch) {
                ReadoutSetNode.this.addBranchReadout(branch);
            }
        });
    }

    private void update() {
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            ReadoutNode readoutNode = (ReadoutNode)this.getChild(i);
            readoutNode.update();
        }
    }

    private void addBranchReadout(Branch branch) {
        this.addChild(this.createReadoutNode(branch));
    }

    protected ReadoutNode createReadoutNode(Branch branch) {
        ReadoutNode readoutNode = new ReadoutNode(this.module, branch, this.module.getSimulationPanel(), new DecimalFormat("0.00"));
        readoutNode.setVisible(false);
        branch.addObserver(this.updater);
        this.update();
        return readoutNode;
    }

    protected void removeBranchReadout(Branch branch) {
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            ReadoutNode readoutNode = (ReadoutNode)this.getChild(i);
            if (readoutNode.getBranch() != branch) continue;
            branch.removeObserver(this.updater);
            this.removeChild(readoutNode);
            --i;
        }
    }

    public boolean isReadoutVisible(Branch branch) {
        return branch.isEditing();
    }

    public void setAllReadoutsVisible(boolean bl) {
        this.circuit.setAllComponentsEditing(bl);
    }
}

