/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.analysis.CircuitSolutionListener;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.TargetReadoutToolNode;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class VirtualAmmeterNode
extends PhetPNode {
    private TargetReadoutToolNode targetReadoutToolNode;
    private Component panel;
    private CCKModule module;
    private Circuit circuit;

    public VirtualAmmeterNode(Circuit circuit, Component component, CCKModule cCKModule) {
        this(new TargetReadoutToolNode(), component, circuit, cCKModule);
    }

    public VirtualAmmeterNode(TargetReadoutToolNode targetReadoutToolNode, Component component, Circuit circuit, CCKModule cCKModule) {
        this.targetReadoutToolNode = targetReadoutToolNode;
        this.panel = component;
        this.module = cCKModule;
        this.circuit = circuit;
        this.targetReadoutToolNode.scale(0.0125);
        this.targetReadoutToolNode.setOffset(1.0, 1.0);
        this.addChild(targetReadoutToolNode);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(VirtualAmmeterNode.this);
                VirtualAmmeterNode.this.translate(pDimension.width, pDimension.height);
                VirtualAmmeterNode.this.update();
            }
        });
        this.addInputEventListener(new CursorHandler());
        cCKModule.getCCKModel().getCircuitSolver().addSolutionListener(new CircuitSolutionListener(){

            public void circuitSolverFinished() {
                VirtualAmmeterNode.this.update();
            }
        });
        circuit.addCircuitListener(new CircuitListenerAdapter(){

            public void junctionRemoved(Junction junction) {
                VirtualAmmeterNode.this.update();
            }

            public void branchRemoved(Branch branch) {
                VirtualAmmeterNode.this.update();
            }

            public void junctionsMoved() {
                VirtualAmmeterNode.this.update();
            }

            public void branchesMoved(Branch[] branchArray) {
                VirtualAmmeterNode.this.update();
            }

            public void junctionAdded(Junction junction) {
                VirtualAmmeterNode.this.update();
            }

            public void junctionsConnected(Junction junction, Junction junction2, Junction junction3) {
                VirtualAmmeterNode.this.update();
            }

            public void junctionsSplit(Junction junction, Junction[] junctionArray) {
                VirtualAmmeterNode.this.update();
            }

            public void branchAdded(Branch branch) {
                VirtualAmmeterNode.this.update();
            }
        });
        this.update();
    }

    public void update() {
        Point2D.Double double_ = new Point2D.Double();
        this.targetReadoutToolNode.localToGlobal(double_);
        this.globalToLocal(double_);
        this.localToParent(double_);
        Branch branch = this.circuit.getBranch(double_);
        if (branch != null) {
            double d = branch.getCurrent();
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            String string = decimalFormat.format(Math.abs(d));
            this.targetReadoutToolNode.setText(string + " " + CCKResources.getString("VirtualAmmeter.Amps"));
        } else {
            this.resetText();
        }
    }

    private void resetText() {
        String[] stringArray = new String[]{CCKResources.getString("VirtualAmmeter.HelpString1"), CCKResources.getString("VirtualAmmeter.HelpString2")};
        this.targetReadoutToolNode.setText(stringArray);
    }
}

