/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.resources.PhetVersion;
import edu.colorado.phet.common.phetcommon.util.DeploymentScenario;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.common.phetcommon.view.util.StringUtil;
import java.util.Locale;

public class PhetApplicationConfig
implements ISimInfo {
    public static final FrameSetup.CenteredWithSize DEFAULT_FRAME_SETUP = new FrameSetup.CenteredWithSize(1024, 768);
    private final String[] commandLineArgs;
    private final String flavor;
    private final PhetResources resourceLoader;
    private FrameSetup frameSetup;
    private PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();

    public PhetApplicationConfig(String[] stringArray, String string) {
        this(stringArray, string, string);
    }

    public PhetApplicationConfig(String[] stringArray, String string, String string2) {
        this.commandLineArgs = stringArray;
        if (this.hasCommandLineArg("-log")) {
            LoggingUtils.enableAllLogging("edu.colorado.phet.common.phetcommon");
        }
        this.flavor = string2;
        this.resourceLoader = new PhetResources(string);
        this.frameSetup = DEFAULT_FRAME_SETUP;
        this.phetLookAndFeel = new PhetLookAndFeel();
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public boolean hasCommandLineArg(String string) {
        return StringUtil.contains(this.commandLineArgs, string);
    }

    public FrameSetup getFrameSetup() {
        return this.frameSetup;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setLookAndFeel(PhetLookAndFeel phetLookAndFeel) {
        this.phetLookAndFeel = phetLookAndFeel;
    }

    public PhetLookAndFeel getLookAndFeel() {
        return this.phetLookAndFeel;
    }

    public PhetResources getResourceLoader() {
        return this.resourceLoader;
    }

    public String getProjectName() {
        return this.resourceLoader.getProjectName();
    }

    public boolean isPreferencesEnabled() {
        return this.isStatisticsFeatureIncluded() || this.isUpdatesFeatureIncluded();
    }

    public String getDistributionTag() {
        return this.resourceLoader.getDistributionTag();
    }

    public String getName() {
        return this.resourceLoader.getName(this.flavor);
    }

    public PhetVersion getVersion() {
        return this.resourceLoader.getVersion();
    }

    public boolean isDev() {
        return this.hasCommandLineArg("-dev");
    }

    public Locale getLocale() {
        return PhetResources.readLocale();
    }

    public boolean isUpdatesFeatureIncluded() {
        return !this.hasCommandLineArg("-updates-off") && DeploymentScenario.getInstance().isUpdatesEnabled();
    }

    public boolean isStatisticsFeatureIncluded() {
        return !this.hasCommandLineArg("-statistics-off") && DeploymentScenario.getInstance().isStatisticsEnabled();
    }

    public boolean isUpdatesEnabled() {
        return this.isUpdatesFeatureIncluded() && PhetPreferences.getInstance().isUpdatesEnabled();
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsFeatureIncluded() && PhetPreferences.getInstance().isStatisticsEnabled();
    }

    public static String getProjectJarName(String string) {
        return string + "_all.jar";
    }
}

