/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class SwingUtils {
    public static JMenuBar addMenuAt(JMenu jMenu, JMenuBar jMenuBar, int n) {
        int n2;
        ArrayList<JMenu> arrayList = new ArrayList<JMenu>();
        for (n2 = 0; n2 < jMenuBar.getMenuCount(); ++n2) {
            if (n2 == n) {
                arrayList.add(jMenu);
            }
            arrayList.add(jMenuBar.getMenu(n2));
        }
        jMenuBar.removeAll();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            JMenu jMenu2 = (JMenu)arrayList.get(n2);
            jMenuBar.add(jMenu2);
        }
        return jMenuBar;
    }

    public static GridBagConstraints getGridBagConstraints(int n, int n2, int n3, int n4, int n5, int n6) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        return gridBagConstraints;
    }

    public static void addGridBagComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6) throws AWTException {
        SwingUtils.addGridBagComponent(container, component, n, n2, n3, n4, n5, n6, new Insets(0, 0, 0, 0));
    }

    public static void addGridBagComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, Insets insets) throws AWTException {
        LayoutManager layoutManager = container.getLayout();
        if (!(layoutManager instanceof GridBagLayout)) {
            throw new AWTException("Invalid layout: " + layoutManager);
        }
        GridBagConstraints gridBagConstraints = SwingUtils.getGridBagConstraints(n, n2, n3, n4, n5, n6);
        gridBagConstraints.insets = insets;
        ((GridBagLayout)layoutManager).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public static void centerWindowOnScreen(Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        window.setLocation((int)(dimension.getWidth() / 2.0 - (double)(window.getWidth() / 2)), (int)(dimension.getHeight() / 2.0 - (double)(window.getHeight() / 2)));
    }

    public static void centerDialogInParent(JDialog jDialog) {
        SwingUtils.centerInParent(jDialog);
    }

    public static void centerInParent(Component component) {
        Container container = component.getParent();
        if (container != null) {
            Rectangle rectangle = container.getBounds();
            Rectangle rectangle2 = new Rectangle((int)(rectangle.getMinX() + rectangle.getWidth() / 2.0 - (double)(component.getWidth() / 2)), (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0 - (double)(component.getHeight() / 2)), component.getWidth(), component.getHeight());
            component.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    public static void centerDialog(JDialog jDialog, Component component) {
        if (component == null) {
            SwingUtils.centerWindowOnScreen(jDialog);
        } else {
            SwingUtils.centerDialogInParent(jDialog);
        }
    }

    public static void fixButtonOpacity(JButton jButton) {
        if (!(UIManager.getLookAndFeel() instanceof MetalLookAndFeel)) {
            jButton.setOpaque(false);
        }
    }

    public static Dimension getMaxDimension(JButton jButton, String string, ImageIcon imageIcon, String string2, ImageIcon imageIcon2) {
        String string3 = jButton.getText();
        Icon icon = jButton.getIcon();
        jButton.setText(string);
        jButton.setIcon(imageIcon);
        Dimension dimension = jButton.getUI().getPreferredSize(jButton);
        jButton.setText(string2);
        jButton.setIcon(imageIcon2);
        Dimension dimension2 = jButton.getUI().getPreferredSize(jButton);
        jButton.setText(string3);
        jButton.setIcon(icon);
        int n = (int)Math.max(dimension.getWidth(), dimension2.getWidth());
        int n2 = (int)Math.max(dimension.getHeight(), dimension2.getHeight());
        return new Dimension(n, n2);
    }

    public static void setBackgroundDeep(Component component, Color color, Class[] classArray, boolean bl) {
        SwingUtils.setForegroundOrBackgroundDeep(false, component, color, classArray, bl);
    }

    private static void setForegroundOrBackgroundDeep(boolean bl, Component component, Color color, Class[] classArray, boolean bl2) {
        Container container;
        Component[] componentArray;
        boolean bl3 = false;
        if (classArray != null) {
            for (int i = 0; i < classArray.length && !bl3; ++i) {
                if (!classArray[i].isInstance(component)) continue;
                bl3 = true;
            }
        }
        if (!bl3) {
            if (bl) {
                component.setForeground(color);
            } else {
                component.setBackground(color);
            }
        }
        if ((!bl3 || bl2) && component instanceof Container && (componentArray = (container = (Container)component).getComponents()) != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingUtils.setForegroundOrBackgroundDeep(bl, componentArray[i], color, classArray, bl2);
            }
        }
    }

    public static void setOpaqueDeep(JComponent jComponent, boolean bl) {
        if (!(jComponent instanceof JTextComponent)) {
            jComponent.setOpaque(bl);
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                Component component = jComponent.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                SwingUtils.setOpaqueDeep((JComponent)component, bl);
            }
        }
    }
}

