/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.test.help;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TestHelpPane
extends PhetApplication {
    private static final int CLOCK_RATE = 25;
    private static final double MODEL_RATE = 1.0;
    private static final Color CANVAS_COLOR_1 = new Color(255, 208, 252);
    private static final Color SCREEN_COLOR_1 = Color.BLUE;
    private static final Color WORLD_COLOR_1 = Color.ORANGE;
    private static final Color CANVAS_COLOR_2 = new Color(208, 255, 252);
    private static final Color SCREEN_COLOR_2 = Color.RED;
    private static final Color WORLD_COLOR_2 = Color.GREEN;

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                try {
                    TestHelpPane testHelpPane = new TestHelpPane(phetApplicationConfig);
                    return testHelpPane;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "piccolo-phet");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    public TestHelpPane(PhetApplicationConfig phetApplicationConfig) throws InterruptedException {
        super(phetApplicationConfig);
        TestModule testModule = new TestModule("Module 1", CANVAS_COLOR_1, SCREEN_COLOR_1, WORLD_COLOR_1);
        this.addModule(testModule);
        TestModule testModule2 = new TestModule("Module 2", CANVAS_COLOR_2, SCREEN_COLOR_2, WORLD_COLOR_2);
        this.addModule(testModule2);
    }

    private static class TestClock
    extends SwingClock {
        public TestClock() {
            super(40, new TimingStrategy.Constant(1.0));
        }
    }

    private static class TestModule
    extends PiccoloModule {
        public TestModule(String string, Color color, Color color2, Color color3) {
            super(string, new TestClock(), true);
            PhetPCanvas phetPCanvas = new PhetPCanvas(new Dimension(1000, 1000));
            this.setSimulationPanel(phetPCanvas);
            phetPCanvas.setBackground(color);
            PPath pPath = new PPath();
            pPath.setPathToEllipse(0.0f, 0.0f, 100.0f, 100.0f);
            pPath.setPaint(color2);
            PText pText = new PText("screen");
            pText.setOffset(pPath.getWidth() / 2.0 - pText.getWidth() / 2.0, pPath.getHeight() / 2.0 - pText.getHeight() / 2.0);
            final PComposite pComposite = new PComposite();
            pComposite.addChild(pPath);
            pComposite.addChild(pText);
            pComposite.setOffset(300.0, 250.0);
            pComposite.addInputEventListener(new CursorHandler());
            pComposite.addInputEventListener(new PDragEventHandler());
            phetPCanvas.addScreenChild(pComposite);
            PPath pPath2 = new PPath();
            pPath2.setPathToRectangle(0.0f, 0.0f, 200.0f, 200.0f);
            pPath2.setPaint(color3);
            PText pText2 = new PText("world");
            pText2.setOffset(pPath2.getWidth() / 2.0 - pText2.getWidth() / 2.0, pPath2.getHeight() / 2.0 - pText2.getHeight() / 2.0);
            final PComposite pComposite2 = new PComposite();
            pComposite2.addChild(pPath2);
            pComposite2.addChild(pText2);
            pComposite2.setOffset(700.0, 100.0);
            pComposite2.addInputEventListener(new CursorHandler());
            pComposite2.addInputEventListener(new PDragEventHandler());
            phetPCanvas.addWorldChild(pComposite2);
            JButton jButton = new JButton("screen button 1");
            jButton.setOpaque(false);
            JButton jButton2 = new JButton("screen button 2");
            jButton2.setOpaque(false);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new TitledBorder("screen panel"));
            jPanel.setBackground(color2);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jButton, "North");
            jPanel.add((Component)jButton2, "South");
            final PSwing pSwing = new PSwing(jPanel);
            pSwing.setOffset(50.0, 450.0);
            phetPCanvas.addScreenChild(pSwing);
            JButton jButton3 = new JButton("world button 1");
            jButton3.setOpaque(false);
            JButton jButton4 = new JButton("world button 2");
            jButton4.setOpaque(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder("world panel"));
            jPanel2.setBackground(color3);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jButton3, "North");
            jPanel2.add((Component)jButton4, "South");
            final PSwing pSwing2 = new PSwing(jPanel2);
            pSwing2.setOffset(850.0, 800.0);
            phetPCanvas.addWorldChild(pSwing2);
            final JCheckBox jCheckBox = new JCheckBox("screen", true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    pComposite.setVisible(jCheckBox.isSelected());
                    pSwing.setVisible(jCheckBox.isSelected());
                }
            });
            final JCheckBox jCheckBox2 = new JCheckBox("world", true);
            jCheckBox2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    pComposite2.setVisible(jCheckBox2.isSelected());
                    pSwing2.setVisible(jCheckBox2.isSelected());
                }
            });
            ControlPanel controlPanel = new ControlPanel();
            this.setControlPanel(controlPanel);
            controlPanel.addControl(jCheckBox);
            controlPanel.addControl(jCheckBox2);
            pPath.addAttribute("name", "screenPath");
            pText.addAttribute("name", "screenText");
            pComposite.addAttribute("name", "screenComposite");
            pPath2.addAttribute("name", "worldPath");
            pText2.addAttribute("name", "worldText");
            pComposite2.addAttribute("name", "worldComposite");
            pSwing.addAttribute("name", "screenPSwing");
            pSwing2.addAttribute("name", "worldPSwing");
            jButton.setName("screenButton1");
            jButton2.setName("screenButton2");
            jPanel.setName("screenPanel");
            jButton3.setName("worldButton1");
            jButton4.setName("worldButton2");
            jPanel2.setName("worldPanel");
            jCheckBox.setName("circleCheckBox");
            jCheckBox2.setName("squareCheckBox");
            HelpPane helpPane = this.getDefaultHelpPane();
            HelpBalloon helpBalloon = new HelpBalloon(helpPane, "no arrow");
            helpBalloon.setLocation(50.0, 200.0);
            helpPane.add(helpBalloon);
            HelpBalloon helpBalloon2 = new HelpBalloon(helpPane, "static point", HelpBalloon.BOTTOM_LEFT, 40.0, 45.0);
            helpBalloon2.pointAt(50.0, 150.0);
            helpPane.add(helpBalloon2);
            HelpBalloon helpBalloon3 = new HelpBalloon(helpPane, "Show screen children", HelpBalloon.RIGHT_BOTTOM, 40.0);
            helpBalloon3.pointAt(jCheckBox);
            helpBalloon3.setArrowFillPaint(color2);
            helpPane.add(helpBalloon3);
            HelpBalloon helpBalloon4 = new HelpBalloon(helpPane, "Show world children", HelpBalloon.RIGHT_TOP, 40.0, -45.0);
            helpBalloon4.pointAt(jCheckBox2);
            helpBalloon4.setArrowFillPaint(color3);
            helpPane.add(helpBalloon4);
            HelpBalloon helpBalloon5 = new HelpBalloon(helpPane, "PComposite screen child", HelpBalloon.BOTTOM_CENTER, 20.0);
            helpBalloon5.pointAt(pComposite, phetPCanvas);
            helpPane.add(helpBalloon5);
            HelpBalloon helpBalloon6 = new HelpBalloon(helpPane, "PText in PComposite", HelpBalloon.LEFT_CENTER, 20.0, -30.0);
            helpBalloon6.pointAt(pText, phetPCanvas);
            helpPane.add(helpBalloon6);
            HelpBalloon helpBalloon7 = new HelpBalloon(helpPane, "PPath in PComposite", HelpBalloon.RIGHT_CENTER, 20.0);
            helpBalloon7.pointAt(pPath, phetPCanvas);
            helpPane.add(helpBalloon7);
            HelpBalloon helpBalloon8 = new HelpBalloon(helpPane, "PSwing screen child", HelpBalloon.BOTTOM_CENTER, 20.0);
            helpBalloon8.pointAt(pSwing, phetPCanvas);
            helpPane.add(helpBalloon8);
            HelpBalloon helpBalloon9 = new HelpBalloon(helpPane, "JPanel in PSwing", HelpBalloon.TOP_CENTER, 20.0);
            helpBalloon9.pointAt(jPanel, pSwing, phetPCanvas);
            helpPane.add(helpBalloon9);
            HelpBalloon helpBalloon10 = new HelpBalloon(helpPane, "JButton in JPanel in PSwing", HelpBalloon.LEFT_BOTTOM, 20.0, -30.0);
            helpBalloon10.pointAt(jButton, pSwing, phetPCanvas);
            helpPane.add(helpBalloon10);
            HelpBalloon helpBalloon11 = new HelpBalloon(helpPane, "PComposite world child", HelpBalloon.BOTTOM_CENTER, 20.0);
            helpBalloon11.pointAt(pComposite2, phetPCanvas);
            helpPane.add(helpBalloon11);
            HelpBalloon helpBalloon12 = new HelpBalloon(helpPane, "PText in PComposite", HelpBalloon.LEFT_CENTER, 20.0, -30.0);
            helpBalloon12.pointAt(pText2, phetPCanvas);
            helpPane.add(helpBalloon12);
            HelpBalloon helpBalloon13 = new HelpBalloon(helpPane, "PPath in PComposite", HelpBalloon.RIGHT_CENTER, 20.0);
            helpBalloon13.pointAt(pPath2, phetPCanvas);
            helpPane.add(helpBalloon13);
            HelpBalloon helpBalloon14 = new HelpBalloon(helpPane, "PSwing world child", HelpBalloon.BOTTOM_CENTER, 20.0);
            helpBalloon14.pointAt(pSwing2, phetPCanvas);
            helpPane.add(helpBalloon14);
            HelpBalloon helpBalloon15 = new HelpBalloon(helpPane, "JPanel in PSwing", HelpBalloon.TOP_CENTER, 20.0);
            helpBalloon15.pointAt(jPanel2, pSwing2, phetPCanvas);
            helpPane.add(helpBalloon15);
            HelpBalloon helpBalloon16 = new HelpBalloon(helpPane, "JButton in JPanel in PSwing", HelpBalloon.LEFT_BOTTOM, 20.0, -30.0);
            helpBalloon16.pointAt(jButton3, pSwing2, phetPCanvas);
            helpPane.add(helpBalloon16);
        }

        public boolean hasHelp() {
            return true;
        }
    }
}

