#include "M5Atom.h"
#include <esp_now.h>
#include <WiFi.h>

// X=1-2-3 --> avvio bersaglio con velocità crescente;  
// x=5 avvio ritorno; x=6 stop ritorno 
typedef struct struct_message {
    int id; // 1 avanti; 2 indietro; 3 stop
    int x;  // velocità andata
    int z;  // distanza frenata
} struct_message;

struct_message myData;

// Motor A
int pin_in1 = 22; // 1 RPWM 
int pin_in2 = 23; // 2 LPWM 

// Pulsante FISICO HOME
int pin_home = 21;

// SENSORE ULTRASUONI
int pin_trig = 33; // define TrigPin
int pin_echo = 19; // define EchoPin.

int MAX_DISTANCE = 350; // Maximum sensor distance is rated at 400-500cm.
float timeOut = MAX_DISTANCE * 60; 
int soundVelocity = 340; // define sound speed=340m/s


// VELOCITA' RITORNO HOME
//const int speedI= 70;  // indietro

int idComando = 0; // 1 avanti, 2 indietro, 3 stop 

// DISTANZA di frenata sicurezza motore a seconda della velocità 1-2-3 del bersaglio
int distStop = 10;
int speedAvanti = 0;  
int speedIndietro= 0;
const int speedIndietroDef= 70;

int btnHome = 1;   // 0 --> go home (pulsante fisico)
int homeRemote = 0;  // 5 --> go home  (pulsante m5_matrix da wifii); 6 --> stop
int distance = 300;
long curMillis, deltaT;
long tempoAvanti, tempoIndietro;

const int DEBUG = 1;   // 0 non debug su seriale

// callback function that will be executed when data is received
void OnDataRecv(const uint8_t * mac, const uint8_t *incomingData, int len) {
  memcpy(&myData, incomingData, sizeof(myData));
  Serial.print("id: "); Serial.println(myData.id);
  Serial.print("x: ");  Serial.println(myData.x);
  Serial.print("z: ");  Serial.println(myData.z);

  M5.dis.clear();
  
  idComando = myData.id;

  // avanti
  if (idComando==1 ) 
  { 
    speedAvanti = myData.x *255/100; 
    distStop= myData.z;
    M5.dis.drawpix(0, 0xff0000);
  } 
  // indietro
  else if (idComando==2 ) 
  {
    homeRemote = 5;
    speedIndietro = myData.x *255/100;
    distStop= myData.z;
    M5.dis.drawpix(0, 0x00ff00);
  }
  // stop
  else if (idComando==3 ) 
  {
    homeRemote= 6;
    speedAvanti = 0;
    speedIndietro = myData.x *255/100;
    //distStop= myData.z;
    M5.dis.drawpix(0, 0x0000ff);
  }

  M5.update();
}

void setup() {
  Serial.begin(115200);

  M5.begin(true, false,true);  // Init Atom-Matrix(Initialize serial port, LED).  
  M5.dis.clear();    

  // sets the pins as outputs:
  pinMode(pin_in1, OUTPUT);
  pinMode(pin_in2, OUTPUT);
  pinMode(pin_home, INPUT_PULLUP);
  pinMode(pin_trig,OUTPUT);// set trigPin to output mode
  pinMode(pin_echo,INPUT); // set echoPin to input mode
  
  dcStop();

  // Set device as a Wi-Fi Station
  WiFi.mode(WIFI_STA);

  // Init ESP-NOW
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  // Once ESPNow is successfully Init, we will register for recv CB to get recv packer info
  esp_now_register_recv_cb(esp_now_recv_cb_t(OnDataRecv));

  // testing
  Serial.print("Testing DC Motor...");
  curMillis = millis();
}

bool flagIndietro = false;

void loop() {
  // 0 premuto e 1 non premuto
  btnHome = digitalRead(pin_home);

  // Distanza bersaglio dal motore
  distance = getDistance();
  
  // ritorno da pulsante locale
  if (btnHome==0) {
        flagIndietro = true;
        speedAvanti= 0;
        if (speedIndietro==0) {speedIndietro = speedIndietroDef;}
        dcIndietro(speedIndietro);
        printDebug("ritorno da pulsante");
  }
  // stop da pulsante locale
  else if (btnHome==1 && flagIndietro == true) {
        flagIndietro = false;
        speedAvanti= 0;
        dcStop();
        printDebug("fermo da pulsante");
  }

  // ritorno da esp-now
  else if (homeRemote==5 && flagIndietro == false) {
        speedAvanti= 0;
        if (speedIndietro==0) {speedIndietro = speedIndietroDef;}
        dcIndietro(speedIndietro);
        printDebug("ritorno esp-now");
  }
  // stop da esp-now
  else if (homeRemote==6) {
        homeRemote = 0;
        speedAvanti= 0;
        dcStop();
        printDebug("fermo esp-now");
    }
  else if (speedAvanti>0) {  
    // frenata per distanza minima
    if (distance<=distStop && distance>=1) { 
        speedAvanti= 0;
        dcStop();
        printDebug("fermo frenata");
    }
    // avvio da esp-now
    else  {
      dcAvanti(speedAvanti);
      printDebug("avanti esp-now");
    }
  } 

  printDebug("");
  deltaT = (millis() - curMillis );
  delay(20);
}


void printDebug(String msg) {
  if (DEBUG==1) {
    if (deltaT>=2000) { 
      curMillis = millis();
      Serial.print("dist. cm "); Serial.println(distance);
      Serial.print("homeRemote "); Serial.println(homeRemote);
      Serial.print("speedAvanti "); Serial.println(speedAvanti);
      Serial.print("btnHome "); Serial.println(btnHome);
      Serial.print("msg "); Serial.println(msg);
    }
  }    
}  

void dcAvanti(int pwm) {
  analogWrite(pin_in1, pwm);
  //analogWrite(pin_in2, 0);
}

void dcIndietro(int pwm) {
  //analogWrite(pin_in1, 0);
  analogWrite(pin_in2, pwm);
}

void dcStop() {
    analogWrite(pin_in1, 0);
    analogWrite(pin_in2, 0);
}

float getDistance() {
  unsigned long pingTime;
  float distance;
  // make trigPin output high level lasting for 10μs to triger HC_SR04
  digitalWrite(pin_trig, HIGH); 
  delayMicroseconds(10);
  digitalWrite(pin_trig, LOW);
  // Wait HC-SR04 returning to the high level and measure out this waitting time
  pingTime = pulseIn(pin_echo, HIGH, timeOut); 
  // calculate the qdistance according to the time
  distance = (float)pingTime * soundVelocity / 2 / 10000; 
  return distance; // return the distance value
}
