#include "M5Atom.h"
#include <esp_now.h>
#include <WiFi.h>

int buttonState = 0;      // Variabile per leggere lo stato del bottone
unsigned long pressTime = 0;    // Tempo di quando il bottone è stato premuto
unsigned long releaseTime = 0;  // Tempo di quando il bottone è stato rilasciato
bool buttonPressed = false;     // Stato del bottone (premuto o no)
unsigned long duration= 0;


// REPLACE WITH YOUR RECEIVER MAC Address
uint8_t broadcastAddress[] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

// Structure example to send data
// Must match the receiver structure
typedef struct struct_message {
    int id; // 1 avanti; 2 indietro; 3 stop
    int x;  // velocità andata
    int z;  // distanza frenata
} struct_message;

// Create a struct_message called myData
struct_message myData;

esp_now_peer_info_t peerInfo;

// callback when data is sent
void OnDataSent(const uint8_t *mac_addr, esp_now_send_status_t status) {
  Serial.print("\r\nLast Packet Send Status:\t");
  Serial.println(status == ESP_NOW_SEND_SUCCESS ? "Delivery Success" : "Delivery Fail");
}

uint8_t  DisBuff[2 + 5 * 5 * 3];  // Used to store RGB color values.

// Set the colors of LED, and save the relevant data to DisBuff[]. 
void setBuff(uint8_t Rdata, uint8_t Gdata, uint8_t Bdata) { 
    DisBuff[0] = 0x05;
    DisBuff[1] = 0x05;
    for (int i = 0; i < 25; i++) {
        DisBuff[2 + i * 3 + 0] = Rdata;
        DisBuff[2 + i * 3 + 1] = Gdata;
        DisBuff[2 + i * 3 + 2] = Bdata;
    }
}


void setup() {
    M5.begin(true, false,true);  // Init Atom-Matrix(Initialize serial port, LED).  
    M5.dis.clear();                
    delay(10);  // delay10ms.  
    //setBuff(0xff, 0x00, 0x00);
    //M5.dis.displaybuff(DisBuff);  // Display the DisBuff color on the LED. 

    // Set device as a Wi-Fi Station
    WiFi.mode(WIFI_STA);
    delay(10);  // delay10ms.
    // Init ESP-NOW
    if (esp_now_init() != ESP_OK) {
      Serial.println("Error initializing ESP-NOW");
      return;
    }
    // Once ESPNow is successfully Init, we will register for Send CB to
    // get the status of Trasnmitted packet
    esp_now_register_send_cb(OnDataSent);
    // Register peer
    memcpy(peerInfo.peer_addr, broadcastAddress, 6);
    peerInfo.channel = 0;  
    peerInfo.encrypt = false;
    // Add peer        
    if (esp_now_add_peer(&peerInfo) != ESP_OK){
      Serial.println("Failed to add peer");
      return;
    }

    // Init Serial Monitor
    Serial.begin(115200);
}


void loop() {
   
   //buttonState =  M5.Btn.wasPressed();
   buttonState =  M5.Btn.isPressed();
   //Serial.println(buttonState);

     // Se il bottone è premuto
   if (buttonState == 1) {
      M5.dis.clear();
      // Se il bottone non era precedentemente premuto
      if (!buttonPressed) {
        // Registra il tempo di pressione
        pressTime = millis();
        buttonPressed = true;
      }
    } else {
      // Se il bottone è rilasciato
      if (buttonPressed) {
        // Registra il tempo di rilascio
        releaseTime = millis();
        // Calcola la durata della pressione del bottone
        duration = releaseTime - pressTime;
        // Stampa la durata sulla seriale
        Serial.print("Il bottone è stato premuto per ");
        Serial.print(duration);
        Serial.println(" millisecondi");
        buttonPressed = false;
      }
    }


    //if (M5.Btn.wasPressed()) {  // Check if the key is pressed.
    if  (duration>0) {
        M5.dis.clear();  
        // Set values to send
        /*
        if  (duration<=1000) { myData.x = 1;  M5.dis.drawpix(0, 0xfff000);}  // Yellow
        else if (duration>1000 && duration <=2000) { myData.x =2; M5.dis.drawpix(0, 0xfff000);M5.dis.drawpix(1, 0xfff000);}  // Yellow
        else  { myData.x =3; M5.dis.drawpix(0, 0xfff000);M5.dis.drawpix(1, 0xfff000);M5.dis.drawpix(2, 0xfff000);}  // Yellow
        */
        myData.id = 1;
        myData.x = 50;
        myData.z = 10;  
        M5.dis.drawpix(0, 0xfff000);
        duration= 0;

        // Send message via ESP-NOW
        esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &myData, sizeof(myData));
        
        if (result == ESP_OK) {
          M5.dis.drawpix(4, 0x00ff00); // Green
          Serial.println("Sent with success" );  Serial.print( myData.x);
        }
        else {
          M5.dis.drawpix(4,  0xff0000); // Red
          Serial.println("Error sending the data");
        }

    }
    
    delay(50);
    M5.update();  // Read the press state of the key. 
    
}
